// `date-input`クラスを持つすべての要素を取得
const inputFields = document.querySelectorAll('.date-ip');

// 取得した各要素に対して処理をループで適用
inputFields.forEach(inputField => {
  // blurイベントのリスナー
  inputField.addEventListener('blur', function() {
    let value = this.value.trim();
    value = value.replace(/[^0-9-]/g, '');
    this.value = value;
    
    const numericValue = value.replace(/-/g, '');
    if (numericValue === '' || isNaN(numericValue)) {
      return;
    }
    
    let fullDate = '';
    
    if (numericValue.length === 8) {
      const year = numericValue.substring(0, 4);
      const month = numericValue.substring(4, 6);
      const day = numericValue.substring(6, 8);
      
      const monthNum = parseInt(month, 10);
      const dayNum = parseInt(day, 10);
      if (monthNum >= 1 && monthNum <= 12 && dayNum >= 1 && dayNum <= 31) {
        fullDate = `${year}-${month}-${day}`;
      }
    } else if (numericValue.length === 4) {
      const year = new Date().getFullYear();
      const month = numericValue.substring(0, 2);
      const day = numericValue.substring(2, 4);
      
      const monthNum = parseInt(month, 10);
      const dayNum = parseInt(day, 10);
      if (monthNum >= 1 && monthNum <= 12 && dayNum >= 1 && dayNum <= 31) {
        fullDate = `${year}-${month}-${day}`;
      }
    } else if (numericValue.length === 1 || numericValue.length === 2) {
      const today = new Date();
      const year = today.getFullYear();
      const month = String(today.getMonth() + 1).padStart(2, '0');
      
      const dayNumber = parseInt(numericValue, 10);
      if (dayNumber >= 1 && dayNumber <= 31) {
        const formattedDay = String(dayNumber).padStart(2, '0');
        fullDate = `${year}-${month}-${formattedDay}`;
      }
    }
    
    if (fullDate) {
      this.value = fullDate;
    }
  });
  
  // inputイベントのリスナー 数字-以外は削除します。
  inputField.addEventListener('input', function() {
    this.value = this.value.replace(/[^0-9-]/g, '');
  });
});

